<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
 <xsl:template match="/">
<html>
<head>
	<title>CONTO DEL BILANCIO PER COMUNI</title>
<style type="text/css">
	td { font-family: tahoma; font-size: 7pt; color: #000000; font-weight: normal;}
	td.intest { font-size: 9pt;}
	table.tabella1 { border-collapse: collapse; border-width: 0}
</style>
</head>
<body bgcolor="#FFFFFF" text="#000000">
<table width="640" border="0" cellspacing="0" cellpadding="3">
  <tr> 
    <td align="center" colspan="3" class="intest"> 
	      <p>
		      <b>CONTO DEL BILANCIO<br /></b>
		      <b>PER COMUNI<br /></b>
	      </p>
      </td>
  </tr>
  <tr> 
    <td width="290">ESERCIZIO: <xsl:value-of select="//Copertina/Esercizio"/> </td>
    <td width="466">ENTE: <xsl:value-of select="//Copertina/NomeEnte"/></td>
    <td width="229">SIGLA PROVINCIA: <xsl:value-of select="//Copertina/Provincia"/></td>
  </tr>
  <tr> 
    <td width="290">CODICE ISTAT: <xsl:value-of select="//Copertina/CodiceIstat"/>
</td>
    <td width="466">DELIBERA DI APPROVAZIONE: N°<xsl:value-of select="//Copertina/NumDelibera"/></td>
    <xsl:variable name="abitanti"  select ="//Copertina/NumAbitanti" />
    <td width="229">NUMERO DI ABITANTI: <xsl:value-of select ="format-number ($abitanti, '#.###.###.###.###.##0', 'european') "/>
    </td>
  </tr>
  <tr> 
    <td width="290">PARTITA IVA: <xsl:value-of select="//Copertina/PartitaIVA"/></td>
    <td width="466">DEL: <xsl:value-of select="//Copertina/DataDelibera/Giorno"/>/<xsl:value-of select="//Copertina/DataDelibera/Mese"/>/<xsl:value-of select="//Copertina/DataDelibera/Anno"/></td>
    	
    <xsl:variable name="superficie"  select ="//Copertina/Superficie" />
    <td width="229">
    SUPERFICIE (kmq): <xsl:value-of select ="//Copertina/Superficie"/>
    </td>
  </tr>
</table><br />
<table width="640" border="0" cellspacing="0" cellpadding="3">
  <tr>
    <td align="center"><b>QUADRO RIASSUNTIVO DELLA GESTIONE FINANZIARIA</b></td>
  </tr>
</table>
<table class="tabella1" border="1" cellspacing="0" cellpadding="3" bordercolor="#000000" width="640">
  <tr> 
    <td width="340">&nbsp;</td>
    <td align="center" width="300" valign="middle" colspan="3">GESTIONE</td>
  </tr>
  <tr> 
    <td width="340">&nbsp;</td>
    <td align="center" width="100" valign="middle">RESIDUI</td>
    <td align="center" width="100" valign="middle">COMPETENZA</td>
    <td align="center" width="100" valign="middle">TOTALE</td>
  </tr>
  <tr> 
    <td width="340"> Fondo di cassa al 1° gennaio</td>
    <td align="right" width="100" valign="middle">=============</td>
    <td align="right" width="100" valign="middle">=============</td>
    	<xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//RisultatoDiGestione/DiffRiscPag/FondoCassaIniziale"/>	
	</xsl:call-template>
  </tr>
  <tr> 
    <td width="340"> RISCOSSIONI</td>
    	<xsl:call-template name="FormattaRiga">
    	<xsl:with-param name="Riga" select="//RisultatoDiGestione/DiffRiscPag/Riscossioni"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td width="340"> PAGAMENTI</td>
    <xsl:call-template name="FormattaRiga">
    	<xsl:with-param name="Riga" select="//RisultatoDiGestione/DiffRiscPag/Pagamenti"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="3" width="540">FONDO DI CASSA AL 31 DICEMBRE</td>
    <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//RisultatoDiGestione/DiffRiscPag/FondoCassaFinale"/>	
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="3" width="540"> PAGAMENTI per azioni esecutive non regolarizzate 
      al 31 dicembre</td>
   <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//RisultatoDiGestione/DiffRiscPag/PagamentiAzioniEsecutive"/>	
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="3" width="540">DIFFERENZA</td>
    <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//RisultatoDiGestione/DiffRiscPag/Differenza"/>	
	</xsl:call-template>
  </tr>
  <tr> 
    <td width="340"> RESIDUI ATTIVI </td>
    <xsl:call-template name="FormattaRiga">
    	<xsl:with-param name="Riga" select="//RisultatoDiGestione/DiffResidui/ResiduiAttivi"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td width="340">RESIDUI PASSIVI </td>
    <xsl:call-template name="FormattaRiga">
    	<xsl:with-param name="Riga" select="//RisultatoDiGestione/DiffResidui/ResiduiPassivi"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="3" width="540"> DIFFERENZA </td>
    <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//RisultatoDiGestione/DiffResidui/Differenza"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td align="center" width="340">&nbsp; </td>
    <td colspan="2" valign="middle">AVANZO (+) O DISAVANZO (-)</td>
     <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//RisultatoDiGestione/AvanzoDisavanzo"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="3">&nbsp;</td>
    <td align="right" width="100" valign="middle">&nbsp;</td>
  </tr>
  <tr> 
    <td valign="middle" rowspan="4" align="right"> RISULTATO DI AMMINISTRAZIONE</td>
    <td colspan="2" valign="middle">- FONDI VINCOLATI</td>
     <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//ElencoFondi/FondiVincolati"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="2" valign="middle">- FONDI PER FINANZIAMENTO SPESE<br />
      &nbsp; IN CONTO CAPITALE</td>
     <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//ElencoFondi/FondiFinaziamento"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="2" valign="middle">- FONDI DI AMMORTAMENTO</td>
     <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//ElencoFondi/FondiAmmortamento"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="2" valign="middle">- FONDI NON VINCOLATI</td>
    <xsl:call-template name="Formatta">
    	<xsl:with-param name="Importo" select="//ElencoFondi/FondiNonVincolati"/>
	</xsl:call-template>
  </tr>
  <tr> 
    <td colspan="4">&nbsp;</td>
  </tr>
</table>
<br />
<br />
<br />
<table width="640" border="0" cellspacing="0" cellpadding="5">
  <tr> 
    <td colspan="2"> 
      <p>--------------------------------------------------------------------------, 
        li --------------------------</p>
      <p>&nbsp;</p>
      </td>
  </tr>
  <tr> 
    <td align="center" width="264">IL SEGRETARIO 
      <p></p>
      <p>------------------------</p>
    </td>
    <td align="center" width="356"> 
      <p>IL RESPONSABILE DEL SERVIZIO FINANZIARIO</p>
      <p>--------------------------------------------------------------------------</p>
    </td>
  </tr>
  <tr> 
    <td colspan="2" align="center"> 
      <p>IL RAPPRESENTANTE LEGALE</p>
      <p>----------------------------------------------</p>
    </td>
  </tr>
</table>
<p>&nbsp;</p>



</body>
</html>

</xsl:template>


<xsl:template name="Formatta">
	   <xsl:param name="Importo" />
	   <xsl:param name="imp1" select="translate($Importo,  ','  , '.' ) "/>
	   <xsl:param  name="imp2" select ="number($imp1)" />
	    <td align="right" width="100" valign="middle">
	 	   		<xsl:value-of select ="format-number ($imp2, '#.###.###.###.###.##0,00', 'european') "/>
	   </td>
	   </xsl:template>	
    


<xsl:template name="FormattaRiga">
		<xsl:param name="Riga"/>
		<xsl:param name="Residui_Virgola" select="$Riga/Residui"/>
		<xsl:param name="Residui_Punto" select="translate($Residui_Virgola,  ','  , '.' ) "/>
		<xsl:param name="Residui" select="number($Residui_Punto)"/>
		
		<xsl:param name="Competenza_Virgola" select="$Riga/Competenza"/>
		<xsl:param name="Competenza_Punto" select="translate($Competenza_Virgola,  ','  , '.' ) "/>
		<xsl:param name="Competenza" select="number($Competenza_Punto)"/>

		
		<xsl:param name="Totale_Virgola" select="$Riga/Totale"/>
		<xsl:param name="Totale_Punto" select="translate($Totale_Virgola,  ','  , '.' ) "/>
		<xsl:param name="Totale" select="number($Totale_Punto)"/>


		
		<td align="right" width="100" valign="middle">
					<xsl:value-of select="format-number ($Residui, '#.###.###.###.###.##0,00', 'european') "/>
		</td>
				
		<td align="right" width="100" valign="middle">
			<xsl:value-of select="format-number ($Competenza, '#.###.###.###.###.##0,00', 'european') "/>
		</td>
		<td align="right" width="100" valign="middle">
			<xsl:value-of select="format-number ($Totale, '#.###.###.###.###.##0,00', 'european') "/>
		</td>
	</xsl:template>
</xsl:stylesheet>
